#include <avr/sleep.h>

#define OUTPUT1_PIN 1
#define OUTPUT2_PIN 2
#define INPUT_PIN 3

bool inputs[][3] = {
	{false, false, true},
  {false, true, true},
  {true, false, true},
  {true, true, false}
};

void setup() {
  pinMode(OUTPUT1_PIN, OUTPUT);  
  pinMode(OUTPUT2_PIN, OUTPUT);  
  pinMode(INPUT_PIN, INPUT);    
  Serial.begin(115200); //Open a serial connection so you can see the output from the serial monitor (Baudrate 115200)
  Serial.println("Logic gate tester");
}

void loop() {
	for(int i=0; i<(sizeof(inputs)/sizeof(inputs[0]));i++)
  {
  	Serial.print("============= Test: ");
    Serial.print(i);
    Serial.println(" =============");
    runTest(inputs[i][0], inputs[i][1], inputs[i][2]);
  }

  //Send the CPU to sleep after one cycle. Useful for simulation
  Serial.flush();
  noInterrupts();
  sleep_enable();
  sleep_cpu();
}

void runTest(bool pin1, bool pin2, bool expected) { 
	Serial.print("A: ");
  Serial.print(pin1);
  digitalWrite(OUTPUT1_PIN, pin1? HIGH:LOW);
  
  Serial.print(" B: ");
  Serial.print(pin2);
  digitalWrite(OUTPUT2_PIN, pin2? HIGH:LOW);
	
  delay(1); //Just add a fraction of delay to make sure the output reading is stable (The serial print is MOOOOORE than enough time)
  
  bool state = digitalRead(INPUT_PIN);
  Serial.print(" Actual: ");
  Serial.print(state);

  Serial.print(" Expected: ");
  Serial.print(expected);
  if(state == expected) 
  {
    Serial.println(" PASS");
  }
  else 
  {
    Serial.println(" FAIL");
  }
}
