//Halloween V2.0 DEEP SLEEP


#include <avr/sleep.h>
#include <avr/power.h>
#include "PinChangeInterrupt.h"

const int buttonPin = 10;
const int buzzerPin = PA1;
const int led1 = 7;
const int led2 = 8;

#define BUTTON_PRESSED LOW

const long debounceDelay = 50L;

#define cs6 1109
#define fs5 740
#define d6 1175
#define c6 1047
#define f5 698
#define b5 988
#define e5 659
#define bf5 932
#define ef5 622
#define b4 494
#define g5 784

// provide a melody as an array.
const uint16_t halloween[] PROGMEM = { 
  cs6, fs5, fs5, cs6, fs5, fs5, cs6, fs5,  d6, fs5,
  cs6, fs5, fs5, cs6, fs5, fs5, cs6, fs5,  d6, fs5,
  cs6, fs5, fs5, cs6, fs5, fs5, cs6, fs5,  d6, fs5,
  cs6, fs5, fs5, cs6, fs5, fs5, cs6, fs5,  d6, fs5,
  cs6, fs5, fs5, cs6, fs5, fs5, cs6, fs5,  d6, fs5,
  cs6, fs5, fs5, cs6, fs5, fs5, cs6, fs5,  d6, fs5,
  c6,  f5,  f5,  c6,  f5,  f5,  c6,  f5,  cs6,  f5,
  c6,  f5,  f5,  c6,  f5,  f5,  c6,  f5,  cs6,  f5,
  cs6, fs5, fs5, cs6, fs5, fs5, cs6, fs5,  d6, fs5,
  cs6, fs5, fs5, cs6, fs5, fs5, cs6, fs5,  d6, fs5,
  c6,  f5,  f5,  c6,  f5,  f5,  c6,  f5,  cs6,  f5,
  c6,  f5,  f5,  c6,  f5,  f5,  c6,  f5,  cs6,  f5,
  b5,  e5,  e5,  b5,  e5,  e5,  b5,  e5,  c6,  e5,
  b5,  e5,  e5,  b5,  e5,  e5,  b5,  e5,  c6,  e5,
  bf5, ef5, ef5, bf5, ef5, ef5, bf5, ef5,  b5, ef5,
  bf5, ef5, ef5, bf5, ef5, ef5, bf5, ef5,  b5, ef5,
  b5,  e5,  e5,  b5,  e5,  e5,  b5,  e5,  c6,  e5,
  b5,  e5,  e5,  b5,  e5,  e5,  b5,  e5,  c6,  e5,
  bf5, ef5, ef5, bf5, ef5, ef5, bf5, ef5,  b5, ef5,
  bf5, ef5, ef5, bf5, ef5, ef5, bf5, ef5,  b5, ef5,
  fs5,  b4,  b4, fs5,  b4,  b4, fs5,  b4,  g5,  b4,
  fs5,  b4,  b4, fs5,  b4,  b4, fs5,  b4,  g5,  b4,
  fs5,  b4,  b4, fs5,  b4,  b4, fs5,  b4,  g5,  b4,
  fs5,  b4,  b4, fs5,  b4,  b4, fs5,  b4,  g5,  b4,
  fs5,  b4,  b4, fs5,  b4,  b4, fs5,  b4,  g5,  b4,
  fs5,  b4,  b4, fs5,  b4,  b4, fs5,  b4,  g5,  b4,
  fs5,  b4,  b4, fs5,  b4,  b4, fs5,  b4,  g5,  b4,
  fs5,  b4,  b4, fs5,  b4,  b4, fs5,  b4,  g5,  b4,
  fs5,  b4,  b4, fs5,  b4,  b4, fs5,  b4,  g5,  b4
};

//define processing variables for the play functionallity

unsigned long previousMillis = 0;
unsigned long pauseBetweenNotes = 218;
unsigned long lengthOfActiveNote = 168;
int noteCounter = 0;
boolean toneOn = false;

volatile boolean playMelody = false;
volatile bool playModeChangeRequested = false;
volatile unsigned long lastDebouncingMillis = 0;

void setup()
{
  pinMode(buttonPin, INPUT_PULLUP);
  pinMode(led1, OUTPUT);
  pinMode(led2, OUTPUT);
  pinMode(buzzerPin, OUTPUT);

  // paranoia setup
  playMelody = false;
  playModeChangeRequested = false;
  lastDebouncingMillis = 0;

  attachPCINT(digitalPinToPCINT(buttonPin), wakeUP, CHANGE);

  stopTheMelody();
  set_sleep_mode(SLEEP_MODE_PWR_DOWN);
  sleep_enable();
  sleep_cpu();
}

void stopTheMelody()
{
  noTone(buzzerPin);
  toneOn = false;
  digitalWrite(led1, toneOn);
  digitalWrite(led2, toneOn);  
}

void startTheMelody()
{
  previousMillis = 0;
  pauseBetweenNotes = 0;
  noteCounter = 0;
  toneOn = false;
  digitalWrite(led1, toneOn);
  digitalWrite(led2, toneOn);  
}

void melody () 
{
  unsigned long currentMillis = millis();
  if (! toneOn && 
      (currentMillis - previousMillis) > pauseBetweenNotes)
  {
    pauseBetweenNotes = 167 * 0.3;
    tone(buzzerPin, pgm_read_word(&halloween[noteCounter]));
    noteCounter++;    
    if (noteCounter > 290)
    {
      // the old program plays the melody only once
      // with resetting the note counter to 0
      // the melody start again and again.
      noteCounter = 0;
    }
    toneOn = true;
    digitalWrite(led1, toneOn);
    digitalWrite(led2, toneOn);  
    previousMillis = currentMillis;
  }
  else if(toneOn && 
          (currentMillis - previousMillis) > lengthOfActiveNote)
  {
    lengthOfActiveNote = 168;
    noTone(buzzerPin);
    toneOn = false;
    digitalWrite(led1, toneOn);
    digitalWrite(led2, toneOn);  
    previousMillis = currentMillis;
  } 
}

void wakeUP()
{ 
    
  lastDebouncingMillis = 0L;
  playModeChangeRequested = true;

  if (!playMelody)
  {

    sleep_disable();
    power_all_enable();
  }
}

void loop()
{
  
  if (lastDebouncingMillis==0 || digitalRead(buttonPin)==BUTTON_PRESSED)
  {

    lastDebouncingMillis = millis();
  }  
  
  if (playModeChangeRequested) 
  {
    unsigned long tempMillis = millis();
    if((tempMillis - lastDebouncingMillis) > debounceDelay)
    {      
      playModeChangeRequested = false;
      playMelody = !playMelody;
      if (!playMelody)
      {
      
        stopTheMelody();
        set_sleep_mode(SLEEP_MODE_PWR_DOWN);
        sleep_enable();
        sleep_cpu();
      }
      else
      {
        startTheMelody();
      }
    }
  }
  
  if(playMelody)
  {
      melody();
  }      
}